/***********************************************************************
*
* AccessPriv uMenu.c
*
* Copyright (c)
* Apple Computer, Inc.  1989-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements
* menus in the AccessPriv program.
*
***********************************************************************/

#include <types.h>
#include <quickdraw.h>
#include <window.h>
#include <event.h>
#include <menu.h>
#include <desk.h>
#include <intmath.h>

#include "ap.h"

extern WmTaskRec        event;
extern unsigned int     quitFlag;

void    doQuitItem()
{
    quitFlag++;
}

void    doAboutItem()
{
    AlertWindow(4, NULL, 0x0001L);
}

void    doMenu()
{
    unsigned int    menuNum, itemNum;

    /* Procedure to handle all menu selections.  Examines the event.TaskData
    * menu item ID word from TaskMaster (from Event Manager) and calls the
    * appropriate routine.  While the routine is running the menu title is
    * still highlighted.  After the routine returns, we unhilight the
    * menu title.
    */

    menuNum = HiWord(event.wmTaskData);
    itemNum = LoWord(event.wmTaskData);

    switch (itemNum) {
        case AboutItem:
            doAboutItem();
            break;
        case QuitItem:
            doQuitItem();
            break;
    }

    HiliteMenu(0, menuNum);     /* Unhighlight the menu title. */
}

void    setUpMenus()
{
    /* Procedure to install our menu titles and their items in the system menu
    * bar and to redraw it so we can see them.
    */

    SetSysBar(NewMenuBar2(refIsResource, 0x0001L, NULL));
    SetMenuBar(NULL);
    
    FixAppleMenu(AppleMenuID);              /* Add DAs to apple menu     */
    FixMenuBar();                           /* Set sizes of menus        */
    DrawMenuBar();                          /* ...and draw the menu bar! */
}
